<?php
/**
 * News Sitemap settings page
 *
 * @package XML Sitemap & Google News
 */

?>
<style type="text/css">
<?php include XMLSF_DIR . '/assets/admin.css'; ?>
</style>
<div class="wrap">

	<h1><?php esc_html_e( 'Google News Sitemap', 'xml-sitemap-feed' ); ?></h1>

	<p>
		<?php printf( /* translators: Writing Settings URL */ esc_html__( 'These settings control the Google News Sitemap generated by the %s plugin.', 'xml-sitemap-feed' ), esc_html__( 'XML Sitemap & Google News', 'xml-sitemap-feed' ) ); ?>
	</p>

	<nav class="nav-tab-wrapper">
		<a href="?page=xmlsf_news&tab=general" class="nav-tab <?php echo 'general' === $active_tab ? 'nav-tab-active' : ''; ?>"><?php echo esc_html( translate( 'General' ) ); ?></a>
		<a href="?page=xmlsf_news&tab=advanced" class="nav-tab <?php echo 'advanced' === $active_tab ? 'nav-tab-active' : ''; ?>"><?php echo esc_html( translate( 'Advanced' ) ); ?></a>
		<?php do_action( 'xmlsf_news_nav_tabs', $active_tab ); ?>
	</nav>

	<div class="main">
		<form id="xmlsf-settings-form" method="post" action="options.php">

			<?php do_action( 'xmlsf_news_settings_before', $active_tab ); ?>

			<?php settings_fields( 'xmlsf_news_' . $active_tab ); ?>

			<?php do_settings_sections( 'xmlsf_news_' . $active_tab ); ?>

			<?php do_action( 'xmlsf_news_settings_after', $active_tab ); ?>

			<?php submit_button(); ?>

		</form>
	</div>

	<div class="sidebar">

		<?php
		if ( is_plugin_active( 'xml-sitemap-feed-advanced-news/xml-sitemap-advanced-news.php' ) && ! $this->compatible_with_advanced() ) {
			$class = 'notice notice-error notice-alt';
			include XMLSF_DIR . '/views/admin/section-advanced-compat-message.php';
		}
		?>

		<h3><span class="dashicons dashicons-welcome-view-site"></span> <?php echo esc_html( translate( 'View' ) ); ?></h3>
		<p>
			<?php
			printf(
				/* translators: Sitemap name with URL */
				esc_html__( 'Open your %s', 'xml-sitemap-feed' ),
				'<strong><a href="' . esc_url( $sitemap_url ) . '" target="_blank">' . esc_html__( 'Google News Sitemap', 'xml-sitemap-feed' ) . '</a></strong><span class="dashicons dashicons-external"></span>'
			);
			?>
		</p>

		<h3><span class="dashicons dashicons-admin-tools"></span> <?php echo esc_html( translate( 'Tools' ) ); ?></h3>
		<form action="" method="post">
			<?php wp_nonce_field( XMLSF_BASENAME . '-help', '_xmlsf_help_nonce' ); ?>
			<p>
				<input type="submit" name="xmlsf-flush-rewrite-rules" class="button button-small" value="<?php esc_html_e( 'Flush rewrite rules', 'xml-sitemap-feed' ); ?>" />
			</p>
			<p>
				<input type="submit" name="xmlsf-check-conflicts-news" class="button button-small" value="<?php esc_html_e( 'Check for conflicts', 'xml-sitemap-feed' ); ?>" />
			</p>
			<p>
				<input type="submit" name="xmlsf-clear-settings-news" class="button button-small button-link-delete" value="<?php esc_attr_e( 'Reset settings', 'xml-sitemap-feed' ); ?>" onclick="javascript:return confirm( '<?php echo esc_js( __( 'This will revert your sitemap settings to the plugin defaults.', 'xml-sitemap-feed' ) ); ?>\n\n<?php echo esc_js( translate( 'Are you sure you want to do this?' ) ); ?>' )" />
			</p>
		</form>

		<?php do_action( 'xmlsf_admin_sidebar', 'news' ); ?>

	</div>

</div>
<script>
document.addEventListener('DOMContentLoaded', function () {
	var mainform, isSubmitting = false;
	jQuery(document).ready(function () {
		mainform = jQuery('#xmlsf-settings-form');
		mainform.submit(function(){
			isSubmitting = true
		})
		mainform.data('initial-state', mainform.serialize());
		jQuery(window).on('beforeunload', function(event) {
			if (!isSubmitting && mainform.length && mainform.serialize() != mainform.data('initial-state')){
				event.preventDefault();
				return "<?php esc_html_e( 'The changes you made will be lost if you navigate away from this page.' ); ?>";
			}
		});
	});
}, false );
</script>
